---
description: "Learn more about: DateTimeZone functions"
title: "DateTimeZone functions"
ms.date: 5/16/2022
ms.custom: "nonautomated-date"
---
# DateTimeZone functions

These functions create and manipulate datetimezone values.

|Name|Description|
|------------|---------------|
|[DateTimeZone.FixedLocalNow](datetimezone-fixedlocalnow.md)|Returns a DateTimeZone value set to the current date, time, and timezone offset on the system.|
|[DateTimeZone.FixedUtcNow](datetimezone-fixedutcnow.md)|Returns the current date and time in UTC (the GMT timezone).|
|[DateTimeZone.From](datetimezone-from.md)|Returns a datetimezone value from a value.|
|[DateTimeZone.FromFileTime](datetimezone-fromfiletime.md)|Returns a DateTimeZone from a number value.|
|[DateTimeZone.FromText](datetimezone-fromtext.md)|Creates a datetimezone from local, universal, and custom datetimezone formats.|
|[DateTimeZone.LocalNow](datetimezone-localnow.md)|Returns a DateTime value set to the current system date and time.|
|[DateTimeZone.RemoveZone](datetimezone-removezone.md)|Returns a datetime value with the zone information removed from the input datetimezone value.|
|[DateTimeZone.SwitchZone](datetimezone-switchzone.md)|Changes the timezone information for the input DateTimeZone.|
|[DateTimeZone.ToLocal](datetimezone-tolocal.md)|Returns a DateTime value from the local time zone.|
|[DateTimeZone.ToRecord](datetimezone-torecord.md)|Returns a record containing parts of a DateTime value.|
|[DateTimeZone.ToText](datetimezone-totext.md)|Returns a text value from a DateTime value.|
|[DateTimeZone.ToUtc](datetimezone-toutc.md)|Returns a DateTime value to the Utc time zone.|
|[DateTimeZone.UtcNow](datetimezone-utcnow.md)|Returns a DateTime value set to the current system date and time in the Utc timezone.|
|[DateTimeZone.ZoneHours](datetimezone-zonehours.md)|Returns a time zone hour value from a DateTime value.|
|[DateTimeZone.ZoneMinutes](datetimezone-zoneminutes.md)|Returns a time zone minute value from a DateTime value.|
|[#datetimezone](sharpdatetimezone.md)|Creates a datetimezone value from year, month, day, hour, minute, second, offset-hours, and offset-minutes.|
